<?php
/*--------------------------------------------------------------------
 OnGetSellingUnitModelEventListener.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Listener;

use Gambio\Shop\ProductModifiers\Modifiers\ValueObjects\ModifierIdentifierInterface;
use Gambio\Shop\Properties\SellingUnitModel\Database\Exceptions\PropertiesValuesIdDoesNotExistExceptions;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesValuesIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\ValueModelDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Service\ReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Configurations\AppendPropertiesModelConfiguration;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitModelEvent;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Model;

/**
 * Class OnGetSellingUnitModelEventListener
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Listener
 */
class OnGetSellingUnitModelEventListener
{
    /**
     * @var ReadServiceInterface
     */
    protected $service;
    
    /**
     * @var AppendPropertiesModelConfiguration
     */
    protected $appendPropertiesModel;
    
    
    /**
     * OnGetSellingUnitModelEventListener constructor.
     *
     * @param ReadServiceInterface               $service
     * @param AppendPropertiesModelConfiguration $appendPropertiesModel
     */
    public function __construct(ReadServiceInterface $service, AppendPropertiesModelConfiguration $appendPropertiesModel)
    {
        $this->service               = $service;
        $this->appendPropertiesModel = $appendPropertiesModel;
    }
    
    
    /**
     *
     * @param OnGetSellingUnitModelEvent $event
     *
     * @throws PropertiesValuesIdDoesNotExistExceptions
     */
    public function __invoke(OnGetSellingUnitModelEvent $event)
    {
        $modifiers = $event->modifierIdentifiers();
        
        if (count($modifiers)) {
    
            $model = $event->model()->value();
            foreach ($modifiers as $modifier) {
                
                if ($modifier->type() === 'property') {
                
                    $valueModelDto = $this->getValueModel($modifier);
                    
                    if ($valueModelDto->valueModel() === '') {
                        
                        continue;
                    }
                    
                    if ($this->appendPropertiesModel->value() === true) {
                        
                        $model .= '-' . $valueModelDto->valueModel();
                        continue;
                    }
                    
                    $model = $valueModelDto->valueModel();
                }
            }
            
            $event->setModel(new Model($model));
        }
    }
    
    
    /**
     * @param ModifierIdentifierInterface $identifier
     *
     * @return ValueModelDto
     * @throws PropertiesValuesIdDoesNotExistExceptions
     */
    protected function getValueModel(ModifierIdentifierInterface $identifier): ValueModelDto
    {
        $dto = new PropertiesValuesIdDto((int)$identifier->value());
        
        return $this->service->valueModel($dto);
    }
}